//
//  Constructing_Your_Own_Dispatch_Queues_with_GCDAppDelegate.m
//  Constructing Your Own Dispatch Queues with GCD
//
//  Created by Vandad Nahavandipoor on 14/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Constructing_Your_Own_Dispatch_Queues_with_GCDAppDelegate.h"

void firstIteration(void *paramContext);
void secondIteration(void *paramContext);
void thirdIteration(void *paramContext);

@implementation Constructing_Your_Own_Dispatch_Queues_with_GCDAppDelegate

@synthesize window = _window;

void firstIteration(void *paramContext){
  
  NSUInteger counter = 0;
  for (counter = 0;
       counter < 5;
       counter++){
    NSLog(@"Pierwsza iteracja, licznik = %lu", (unsigned long)counter);
  }
}

void secondIteration(void *paramContext){
  
  NSUInteger counter = 0;
  for (counter = 0;
       counter < 5;
       counter++){
    NSLog(@"Druga iteracja, licznik = %lu", (unsigned long)counter);
  }
}

void thirdIteration(void *paramContext){
  
  NSUInteger counter = 0;
  for (counter = 0;
       counter < 5;
       counter++){
    NSLog(@"Trzecia iteracja, licznik = %lu", (unsigned long)counter);
  }
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  dispatch_queue_t firstSerialQueue = 
  dispatch_queue_create("com.pixolity.GCD.serialQueue1", 0);
  
  dispatch_async_f(firstSerialQueue, NULL, firstIteration);
  dispatch_async_f(firstSerialQueue, NULL, secondIteration);
  dispatch_async_f(firstSerialQueue, NULL, thirdIteration);
  
  dispatch_release(firstSerialQueue);
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

//- (BOOL)            application:(UIApplication *)application
//  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
//  
//  dispatch_queue_t firstSerialQueue = 
//  dispatch_queue_create("com.pixolity.GCD.serialQueue1", 0);
//  
//  dispatch_async(firstSerialQueue, ^{
//    NSUInteger counter = 0;
//    for (counter = 0;
//         counter < 5;
//         counter++){
//      NSLog(@"Pierwsza iteracja, counter = %lu", (unsigned long)counter);
//    }
//  });
//  
//  dispatch_async(firstSerialQueue, ^{
//    NSUInteger counter = 0;
//    for (counter = 0;
//         counter < 5;
//         counter++){
//      NSLog(@"Druga iteracja, counter = %lu", (unsigned long)counter);
//    }
//  });
//  
//  dispatch_async(firstSerialQueue, ^{
//    NSUInteger counter = 0;
//    for (counter = 0;
//         counter < 5;
//         counter++){
//      NSLog(@"Trzecia iteracja, counter = %lu", (unsigned long)counter);
//    }
//  });
//  
//  dispatch_release(firstSerialQueue);
//  
//  self.window = [[UIWindow alloc] initWithFrame:
//                 [[UIScreen mainScreen] bounds]];
//  self.window.backgroundColor = [UIColor whiteColor];
//  [self.window makeKeyAndVisible];
//  return YES;
//}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
